<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class SaleBill extends Model 
{

    protected $table = 'sale_bills';
    public $timestamps = true;
    protected $fillable = array('client_id', 'package_id', 'entry_day', 'checkout_day', 'entry_time', 'checkout_time', 'status', 'notes', 'discount', 'user_id');

    public function client()
    {
        return $this->belongsTo('App\Models\Client');
    }

    public function package()
    {
        return $this->belongsTo('App\Models\Package');
    }

    public function products()
    {
        return $this->belongsToMany('App\Models\Product')->withPivot('price','quantity','discount');
    }

    public function sale_bill_payments()
    {
        return $this->hasMany('App\Models\SaleBillPayment');
    }

    public function user()
    {
        return $this->belongsTo('App\Models\User');
    }

}